<?php
/*
 * import and aliasing for :
 * - Amazon
 * - Signature
 * - Search
 * - Lookup
 * - Param
 */
require_once SCRIPT_PATH . 'Amazon.php';
require_once SCRIPT_PATH . 'Signature.php';
require_once SCRIPT_PATH . 'Exception.php';
require_once SCRIPT_PATH . 'Request/Search.php';
require_once SCRIPT_PATH . 'Request/Lookup.php';
require_once SCRIPT_PATH . 'Request/Param.php';

final class Request {
    
    /**
     *
     * Amazon_Request object
     * @staticvar null|object
     */
    static private $_obj = null;
    
    /**
     *
     * Amazon object
     * @var object
     */
    private $_amazon = null;
    
    /**
     *
     * Operation to proceed
     * @var string
     */
    private $_operation;  
    
    /**
     *
     * A data if operation is search
     * @var string
     */
    private $_keyword;
    
    /**
     *
     * A data if operation is lookup
     * @var string
     */
    private $_asin;
    
    /**
     *
     * Amazon_Request_Param object
     * @var object
     */
    private $_params;        
    
    /**
     * Denied object instantiation
     * @access private
     * @return void 
     */
    private function __construct() {}
    
    /**
     *
     * Create Amazon_Request object
     * 
     * @access public
     * @return object
     * @static
     */
    static public function getInstance() {
        
        if( is_null(self::$_obj) ) {
            self::$_obj = new Request();
        }
        
        return self::$_obj;
        
    }
    
    /**
     *
     * Set Amazon object
     * 
     * @access public
     * @param Amazon $obj
     * @throws Amazon_Exception 
     * @return void
     */
    public function setAmazon(Amazon $obj) {
        
        if( $obj instanceof Amazon) {
            $this->_amazon = $obj;
        }else{
            throw new Amazon_Exception('Given object must be an instance of Amazon class.');
        }
        
    }
    
    /**
     *
     * Set parameters and Amazon_Request_Param object
     * 
     * @access public
     * @param array $params 
     * @return void
     */
    public function setParams( $params ) {
        
        $param = Param::getInstance();
        $param->setParams($params);
        
        $this->_params = $param;
        
    }
    
    /**
     * Search item in amazon
     * 
     * @access public
     * @param string $keyword 
     */
    public function search( $keyword ) {
        
        $keyword = trim($keyword);
        
        if( !empty($keyword) ) {
            $this->_operation = 'search';
            $this->_keyword = $keyword;            
        }
        
    }
    
    /**
     *
     * Get detail information about given item asin id
     * 
     * @access public
     * @param string $asin 
     */
    public function detail( $asin ) {
        
        $asin = trim($asin);
        
        if( !empty($asin) ) {
            $this->_operation = 'lookup';
            $this->_asin = $asin;
        }
        
    }
    
    /**
     *
     * Send request to Amazon server
     * 
     * @access public
     * @throws Amazon_Exception      
     */
    public function send() {
        
        if( empty($this->_operation) ) {
            throw new Amazon_Exception('You must set operation first before send request.');
        }else{
            
            $className = ucfirst($this->_operation);
            switch( $className ) {
                
                case 'Search':
                    $data = $this->_keyword;
                    $classObj = Search::getInstance();                    
                    break;
                
                case 'Lookup':
                    $data = $this->_asin;
                    $classObj = Lookup::getInstance();
                    break;
                
            }
            
            $signature = Signature::getInstance();                        
            $signature->init($this->_amazon,$this->_params);
            
            $classObj->setData($data);
            $classObj->setSignature($signature);
            
            $url = $classObj->build();
            return $url;
        }
        
    }        
    
}
