<?php
/*
 * import and aliasing data for :
 * - Base
 */
require_once SCRIPT_PATH . 'Request/Base.php';

final class Search extends Base {
    
    /**
     *
     * Search Object
     * @staticvar null|object
     */
    static private $_obj = null;            
    
    /**
     * Denied direct object instantiation
     * 
     * @access private
     * @return void 
     */
    private function __construct() {}
    
    /**
     *
     * Create Search object
     * 
     * @access public
     * @return Search
     * @static
     */
    static public function getInstance() {
        
        if( is_null(self::$_obj) ) {
            self::$_obj = new Search();
        }
        
        return self::$_obj;
        
    }                        
    
    /**
     *
     * Get signatured request
     * 
     * @access public
     * @uses Amazon_Signature
     * @return string     
     */
    public function build() {                
        
        return $this->_signature->create(array(
            'Keywords' => $this->_data,
            'Operation' => 'ItemSearch'
        ));
        
    }
    
}
